% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_document_corpus.R
\name{get_document_corpus}
\alias{get_document_corpus}
\title{Get Document Corpus}
\usage{
get_document_corpus(
  doctype = "digibok",
  author = NULL,
  ddk = NULL,
  freetext = NULL,
  subject = NULL,
  from_timestamp = NULL,
  to_timestamp = NULL,
  publisher = NULL,
  limit = 10,
  order_and_limit_by_rank = NULL,
  title = NULL,
  from_year = NULL,
  to_year = NULL,
  fulltext = NULL,
  lang = "nob"
)
}
\arguments{
\item{doctype}{Character, document type (default: 'digibok')}

\item{author}{Character, author name (default: NULL)}

\item{ddk}{Character, Dewey Decimal Classification (default: NULL)}

\item{freetext}{Character, free text search (default: NULL)}

\item{subject}{Character, subject of the document (default: NULL)}

\item{from_timestamp}{Character, timestamp range start (default: NULL)}

\item{to_timestamp}{Character, timestamp range end (default: NULL)}

\item{publisher}{Character, publisher name (default: NULL)}

\item{limit}{Integer, maximum number of results (default: 10)}

\item{order_and_limit_by_rank}{Logical, order and limit results by rank (default: NULL)}

\item{title}{Character, title of the document (default: NULL)}

\item{from_year}{Integer, year range start (default: NULL)}

\item{to_year}{Integer, year range end (default: NULL)}

\item{fulltext}{Character, full text search (default: NULL)}

\item{lang}{Character, language code (default: 'nob')}
}
\value{
A data frame of metadata
}
\description{
Retrieve a corpus of documents based on the given parameters.
}
\examples{
  get_document_corpus(doctype = 'digibok', author = 'Henrik Ibsen', limit = 2)

}
