% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggridR.R
\name{dgrectgrid}
\alias{dgrectgrid}
\title{Return the coordinates constituting the boundary of cells within a
         specified region}
\usage{
dgrectgrid(dggs, minlat = -1, minlon = -1, maxlat = -1, maxlon = -1,
  frame = TRUE, wrapcells = TRUE, savegrid = FALSE)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{minlat}{Minimum latitude of region of interest}

\item{minlon}{Minimum longitude of region of interest}

\item{maxlat}{Maximum latitude of region of interest}

\item{maxlon}{Maximum longitude of region of interest}

\item{frame}{If TRUE, return a data frame suitable for ggplot plotting.
If FALSE, return an OGR poly object}

\item{wrapcells}{Cells which cross -180/180 degrees can present 
difficulties for plotting. Setting this TRUE will result in
cells with components in both hemispheres to be mapped
entirely to positive degrees (the Eastern hemisphere). As a
result, such cells will have components in the range
[180,360). Only used when \code{frame=TRUE}.}

\item{savegrid}{If savegrid is true then a KML representation of the grid is
produced and the filename returned. No other manipulations
are done. Setting this true overrides all other arguments.}
}
\value{
Returns a data frame or OGR poly object, as specified by \code{frame}.
        If \code{savegrid=TRUE}, returns a filename.
}
\description{
Note: This may generate odd results for very large
                 rectangles, because putting rectangles on spheres is
                 weird... as you should know, if you're using this package.
}
\examples{
library(dggridR)
dggs <- dgconstruct(spacing=1000,metric=FALSE,resround='down')

#Get grid cells for the conterminous United States
grid <- dgrectgrid(dggs,
               minlat=24.7433195, minlon=-124.7844079, 
               maxlat=49.3457868, maxlon=-66.9513812, frame=TRUE)

}

