% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{add_booklet}
\alias{add_booklet}
\title{Add response data for a booklet to a project}
\usage{
add_booklet(db, x, booklet_id, auto_add_unknown_rules = FALSE)
}
\arguments{
\item{db}{A handle to the database, i.e. the output of \code{start_new_project}
or \code{open_project}}

\item{x}{A data frame containing the responses and, optionally,
person person_properties. The data.frame should have one row per respondent and the column names should 
correspond to the item_id's in the rules or the names of the person_properties. See details.}

\item{booklet_id}{A (short) string identifying the test form (booklet)}

\item{auto_add_unknown_rules}{If FALSE (the default), an error will be generated if 
some of the responses do not appear in the scoring rules. If TRUE, unknown responses will be
assumed to have a score of 0.}
}
\value{
A list of with information about the recent import.
\item{not_listed}{A data frame of all responses that will be treated as missing}
}
\description{
Adds item response data for a test form (a.k.a. booklet)
}
\details{
It is a common practice to keep respons data in tables where each row 
contains the responses from a single person. This function is provided to input
data in that form, one booklet at a time. The starting point is a data frame.
Getting the data frame into R is left to the user. We have found packages
\code{readxl} to be very good at reading Excel sheets, and \code{haven} quite
efficient with SPSS files.

If the dataframe \code{x} contains a variable named \code{person_id} this variable 
will be used to identify unique persons. It is assumed that a single person will only 
make a single booklet once, otherwise an error will be generated. 

If a person_id is not supplied, dexter will generate unique person_id's for each row of data.  

Any column whose name has an exact match in the scoring rules inputted with
function \code{start_new_project} will be treated as an item; any column whose name has an 
exact match in the person_properties will be treated as a person property. If a name matches both
a person_property and an item, the item takes precedence. Columns other than items, person properties 
and person_id will be ignored.

Note that responses are always treated as strings, and \code{NA}
values are transformed to the string \code{"NA"}.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", 
                       person_properties=list(gender="unknown"))
head(verbAggrData)
add_booklet(db, verbAggrData, "agg")      

close_project(db)
}

}
