% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option.R
\name{save_scenarios}
\alias{save_scenarios}
\title{Save Evaluation Results of Scenarios to a File}
\usage{
save_scenarios(scenarios_results, file_name)
}
\arguments{
\item{scenarios_results}{List of \code{numeric} vectors with scenario
evaluation results.}

\item{file_name}{A \code{character}, to name the file for saving the scenario
results.}
}
\value{
No return value, called for side effects
}
\description{
Stores the results of scenario evaluations into a file for later analysis.
}
\examples{
tree <- dexisensitivity::masc2
option <- create_options(tree, num_options=3, seed = 42)
scenarios <- evaluate_scenarios(tree, option)
save_scenarios(scenarios,paste0(tempdir(),"\\\\save_scenarios.tab"))
file.remove(paste0(tempdir(),"\\\\save_scenarios.tab"))

}
