% Generated by roxygen2 (4.0.0): do not edit by hand
\name{help}
\alias{?}
\alias{help}
\title{Drop-in replacements for help and ? functions}
\usage{
help(topic, package = NULL, ...)

"?"(e1, e2)
}
\arguments{
\item{topic}{A name or character string specifying the help topic.}

\item{package}{A name or character string specifying the package in which
to search for the help topic. If NULL, seach all packages.}

\item{e1}{First argument to pass along to \code{utils::`?`}.}

\item{e2}{Second argument to pass along to \code{utils::`?`}.}

\item{...}{Additional arguments to pass to \code{\link[utils]{help}}.}
}
\description{
The \code{?} and \code{help} are drop-in replacements for functions of the
same name in the utils package.
}
\details{
The \code{?} function is a replacement for \code{\link[utils]{?}} from the
utils package. It will search for help in devtools-loaded packages first,
then in regular packages.

The \code{help} function is a replacement for \code{\link[utils]{help}} from
the utils package. If \code{package} is not specified, it will search for
help in devtools-loaded packages first, then in regular packages. If
\code{package} is specified, then it will search for help in devtools-loaded
packages or regular packages, as appropriate.
}
\examples{
\dontrun{
# This would load devtools and look at the help for load_all, if currently
# in the devtools source directory.
load_all()
?load_all
help("load_all")
}

# To see the help pages for utils::help and utils::`?`:
help("help", "utils")
help("?", "utils")
}

