% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_phenoBDD.R
\name{devRateIBMdataBase}
\alias{devRateIBMdataBase}
\title{Forecast ectotherm phenology as a function of temperature and development rate models
available in the package database}
\usage{
devRateIBMdataBase(
  tempTS,
  timeStepTS,
  eq,
  species,
  lifeStages,
  numInd = 10,
  stocha,
  timeLayEggs = 1
)
}
\arguments{
\item{tempTS}{The temperature time series (a vector).}

\item{timeStepTS}{The time step of the temperature time series (a numeric with 1 = one day).}

\item{eq}{The name of the equation (e.g., lactin2_95).}

\item{species}{The species for the model (e.g., "Sesamia nonagrioides").}

\item{lifeStages}{The life stages available for the species and the model.}

\item{numInd}{The number of individuals for the simulation (an integer).}

\item{stocha}{The standard deviation of a Normal distribution centered on
development rate to create stochasticity among individuals (a numeric).}

\item{timeLayEggs}{The delay between emergence of adults and the time where
females lay eggs in time steps (a numeric).}
}
\value{
A list with three elements: the table of phenology for each individual,
   the models used (nls objects), and the time series for temperature.
}
\description{
Forecast ectotherm phenology as a function of temperature and development rate models
available in the package database
}
\examples{
forecastLactin2_95 <- devRateIBMdataBase(
  tempTS = rnorm(n = 20, mean = 20, sd = 1),
  timeStepTS = 10,
  eq = lactin2_95,
  species = "Sesamia nonagrioides",
  lifeStages = c("eggs", "larva", "pupa"),
  numInd = 10,
  stocha = 0.015,
  timeLayEggs = 1
)
}
