% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom-dist.R
\name{binom_plot}
\alias{binom_perc}
\alias{binom_plot}
\alias{binom_prob}
\title{Visualize Binomial Distribution}
\usage{
binom_plot(n, p)

binom_prob(n, p, s, type = c("lower", "upper", "exact", "interval"))

binom_perc(n, p, tp, type = c("lower", "upper"))
}
\arguments{
\item{n}{number of trials}

\item{p}{aggregate probability}

\item{s}{number of success}

\item{type}{lower/upper/exact/interval}

\item{tp}{the probability of success in a trial}
}
\value{
a list containing the following components:

\item{avg}{mean of the binomial distribution}
\item{stdev}{standard deviation of the binomial distribution}
\item{prob}{probability of s success}
}
\description{
Visualize how changes in number of trials and the probability of
success affect the shape of the binomial distribution. compute\/visualize
probability from a given quantile and quantiles out of given probability.
}
\examples{
# visualize binomial distribution
binom_plot(10, 0.3)

# compute\\/visualize probability from a given quantile
binom_prob(10, 0.3, 4, type = 'exact')
binom_prob(10, 0.3, 4, type = 'lower')
binom_prob(10, 0.3, 4, type = 'upper')
binom_prob(10, 0.3, c(4, 6), type = 'interval')

# compute\\/visualize quantiles out of given probability
binom_perc(10, 0.5, 0.05)
binom_perc(10, 0.5, 0.05, "upper")
}
\seealso{
\code{\link[stats]{Binomial}}
}

