% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_means.R
\name{proc_means}
\alias{proc_means}
\title{Replica of SAS's PROC MEANS}
\usage{
proc_means(df, vars = NULL, var_order = NULL, by = NULL, n = T,
  mean = TRUE, sd = TRUE, min = TRUE, max = TRUE, median = FALSE,
  q1 = FALSE, q3 = FALSE, iqr = FALSE, nmiss = FALSE,
  nobs = FALSE, p = FALSE, p_round = 4, display_round = 3)
}
\arguments{
\item{df}{A data frame or tibble.}

\item{vars}{Character vector of numeric variables to generate descriptive
statistics for. If the default (\code{NULL}), all variables are included,
except for any specified in \code{by}.}

\item{var_order}{Character vector listing the variable names in the order
results should be displayed. If the default (\code{NULL}), variables are
displayed in the order specified in \code{vars}.}

\item{by}{Discrete variable. Separate statistics will be produced for
each level. Default \code{NULL} provides statistics for all observations.}

\item{n}{logical. Display number of rows with values. Default \code{TRUE}.}

\item{mean}{logical. Display mean value. Default \code{TRUE}.}

\item{sd}{logical. Display standard deviation. Default \code{TRUE}.}

\item{min}{logical. Display minimum value. Default \code{TRUE}.}

\item{max}{logical. Display maximum value. Default \code{TRUE}.}

\item{median}{logical. Display median value. Default \code{FALSE}.}

\item{q1}{logical. Display first quartile value. Default \code{FALSE}.}

\item{q3}{logical. Display third quartile value. Default \code{FALSE}.}

\item{iqr}{logical. Display interquartile range. Default \code{FALSE}.}

\item{nmiss}{logical. Display number of missing values. Default \code{FALSE}.}

\item{nobs}{logical. Display total number of rows. Default \code{FALSE}.}

\item{p}{logical. Calculate p-value across \code{by} groups using \code{aov}.
Ignored if no \code{by} variable specified. Default \code{FALSE}.}

\item{p_round}{Number of decimal places p-values should be rounded to.}

\item{display_round}{Number of decimal places displayed values should be 
rounded to}
}
\value{
A data.frame with columns variable, \code{by} variable, and
  a column for each summary statistic.
}
\description{
Descriptive statistics for continuous variables, with the option of
stratifying by a categorical variable.
}
\examples{
proc_means(iris, vars = c("Sepal.Length", "Sepal.Width"))
proc_means(iris, by = "Species")

}
