% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-oo-api.R
\name{desc_get_field}
\alias{desc_get_field}
\alias{desc_get_or_fail}
\alias{desc_get_list}
\title{Get a single field from a DESCRIPTION file, fail if not found}
\usage{
desc_get_field(
  key,
  default = stop("Field '", key, "' not found"),
  trim_ws = TRUE,
  squish_ws = trim_ws,
  file = "."
)

desc_get_or_fail(keys, file = ".")

desc_get_list(
  key,
  default = stop("Field '", key, "' not found"),
  sep = ",",
  trim_ws = TRUE,
  squish_ws = trim_ws,
  file = "."
)
}
\arguments{
\item{key}{The field to query.}

\item{default}{Value to return if \code{key} is not found.
By default it throws an error.}

\item{trim_ws}{Whether to trim leading and trailing whitespace
from the value. Defaults to \code{TRUE}.}

\item{squish_ws}{Whether to reduce repeated whitespace in the value.
Defaults to \code{trim_ws}.}

\item{file}{DESCRIPTION file to use. By default the DESCRIPTION
file of the current package (i.e. the package the working directory
is part of) is used.}

\item{keys}{Character vector of fields to get.}

\item{sep}{Separator string for \code{desc_get_list()}.}
}
\value{
Character string, the value of \code{key}, or \code{default}
  if \code{key} is not found and \code{default} is specified.
}
\description{
\code{desc_get_list()} parses a comma separated list into a character
vector.
}
\seealso{
Other simple queries: 
\code{\link{desc_del}()},
\code{\link{desc_fields}()},
\code{\link{desc_get}()},
\code{\link{desc_has_fields}()},
\code{\link{desc_set}()}
}
\concept{simple queries}
