% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputecount.R
\name{imputecount}
\alias{imputecount}
\title{Imputation of count data with the Iterated Stable Autoencoder}
\usage{
imputecount(X, threshold = 1e-08, maxiter = 1000, delta = 0.5,
  transformation = c("None", "CA"))
}
\arguments{
\item{X}{a data frame or a matrix with count data containing missing values}

\item{threshold}{for assessing convergence (difference between two successive iterations)}

\item{maxiter}{integer, maximum number of iterations of the iterative imputation algorithm}

\item{delta}{numeric, probability of deletion of each cell of
the data matrix. By default delta = 0.5}

\item{transformation}{estimate a transformation of the original matrix; currently,
only correspondence analysis CA is available}
}
\value{
mu.hat the estimator of the signal

completeObs the completed data set. The observed values are kept for the non-missing entries and the missing values are replaced by the predicted ones
}
\description{
This function estimates a low-rank signal from a noisy count incomplete data
using the Iterated Stable Autoencoder. It can be used to impute a data set.
}
\details{
Impute the missing entries of a count data set using the iterative ISA algorithm.
The iterative ISA algorithm first consists in imputing missing values with initial values. 
Then, ISA is performed on the completed dataset with its regularization parameter delta. The missing entries are imputed with the estimated signal. These steps of estimation of the signal via ISA and imputation of the missing values are iterated until convergence.
}
\examples{
#
}
\seealso{
\code{\link{ISA}}
}

