% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{principal}
\alias{principal}
\title{Principal measure}
\usage{
principal(angle, angleUnit = c("deg", "rad"))
}
\arguments{
\item{angle}{numeric vector of angle.}

\item{angleUnit}{The unit of \code{angle}. Either "deg" or "rad".
Default is "deg".}
}
\value{
A matrix of principal measure of angle in both radian and in degree units.
}
\description{
Principal measure of an angle value.
Principal measure ranges from -pi to pi for radian unit while it ranges from
-180 to 180 for degree unit.
}
\note{
Use \code{principal} in position computations, not distance computations.
}
\examples{
principal(303)
principal(23 * pi/8, "rad")
}
\seealso{
\code{\link{rad}} for radian, \code{\link{deg}} for degree,
\code{\link{slope2angle}} for slope to angle conversion,
\code{\link{angle2slope}} for angle to slope conversion.
}
