% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_plot.R
\name{fill_plot}
\alias{fill_plot}
\title{Plot gap-filled dendrometer series}
\usage{
fill_plot(dm.data, dm.gpf, sensor = 1, year = NULL,
          period = NULL)
}
\arguments{
\item{dm.data}{a \code{data.frame} with a timestamp (\code{\%Y-\%m-\%d \%H:\%M:\%S} format) as row names, and dendrometer series in columns. Output as created using code from the \code{Import dendrometer data} vignette.}

\item{dm.gpf}{a \code{data.frame} with gap-filled dendrometer series as produced by \code{\link{fill_gaps}}.}

\item{sensor}{a \code{numeric} specifying the sensor to be plotted (by column number). Defaults to 1 (first dendrometer series in both \code{data.frames}).}

\item{year}{a \code{numeric} specifying the year(s) to be plotted. Defaults to the first year in the dataset. Two consecutive years (e.g., for a growing season at the Southern Hemisphere) can be defined with \code{year = c(year1, year2)}.}

\item{period}{a \code{numeric} indicating the period to be plotted, specified using day of year values (begin and end). Defaults to the complete data period.}
}
\value{
Plot.
}
\description{
The function creates a plot with gap-filled and original dendrometer series.
}
\details{
The function creates a plot showing the gap-filling results for a single dendrometer series over a specified time window. Although the function is intended to plot short time periods (within a growing season), it can plot two calendar years at maximum (e.g., 2014-2015), thereby allowing the visualization of a complete growing season at the Southern Hemisphere as well.
}
\examples{
\dontrun{

data(dmCD)
## creating some artificial gaps (for demonstration purposes):
dmCD[c(873:877,985:990),1] <- NA
dm.gpf <- fill_gaps(dmCD, Hz = 0.01)
fill_plot(dmCD, dm.gpf, period = c(137,144))
}

}
\author{
Olivier Bouriaud, Ernst van der Maaten and Marieke van der Maaten-Theunissen.
}

