% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/noded_with_condition.R
\name{which_node}
\alias{which_node}
\title{Which node id is common to a group of labels}
\usage{
which_node(dend, labels, max_id = TRUE, ...)
}
\arguments{
\item{dend}{a dendrogram dend}

\item{labels}{a character vector of labels from the tree}

\item{max_id}{logical (TRUE) - if to return only the max id}

\item{...}{ignored.}
}
\value{
An integer with the id(s) of the nodes which includes all of the labels.
}
\description{
This function identifies which edge(s) in a tree has group of labels ("tips") in common.
By default it only returns the edge (node) with the heighest id.
}
\examples{
dend <- iris[1:10,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram \%>\% set("labels", 1:10)
dend \%>\% plot

which_node(dend, c(1,2), max_id = FALSE)
which_node(dend, c(2,3), max_id = FALSE)
which_node(dend, c(2,3))

dend \%>\% plot
the_h <- get_nodes_attr(dend, "height", which_node(dend, c(4,6)))
the_h
abline(h = the_h, lty = 2, col = 2)
get_nodes_attr(dend, "height", which_node(dend, c(4,6)))
get_nodes_attr(dend, "members", which_node(dend, c(4,6)))
}
\seealso{
\link{noded_with_condition}, \link{branches_attr_by_clusters},
\link{nnodes}, \link{branches_attr_by_labels}, \link{get_nodes_attr}
\link[ape]{which.edge}
}

