% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dendlist}
\alias{dendlist}
\alias{plot.dendlist}
\title{Creating a dendlist object from several dendrograms}
\usage{
dendlist(...)

\method{plot}{dendlist}(x, which = c(1L, 2L), ...)
}
\arguments{
\item{...}{several dendrogram/hclust/phylo or dendlist objects
If an object is hclust or phylo - it will be converted
into a dendrogram.}

\item{x}{a dendlist object}

\item{which}{an integer vector of length 2, indicating
which of the trees in the dendlist object should be plotted (relevant for dendlist)}
}
\value{
A list of class dendlist where each item
is a dendrogram
}
\description{
It accepts several dendrograms and or dendlist objects
and chain them all together.
This function aim to help with the usability of
comparing two or more dendrograms.
}
\details{
It there are list() in the ..., they are omitted.
If ... is missing, it returns an empty dendlist.
}
\examples{
\dontrun{

dend <- iris[,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend2 <- iris[,-5] \%>\% dist \%>\% hclust(method = "single") \%>\% as.dendrogram
dendlist(1:4, 5, a=dend) # Error
# dendlist <- function (...) list(...)
dendlist(dend)
dendlist(dend, dend)
dendlist(dend, dend, dendlist(dend))
#  notice how the order of
dendlist(dend, dend2)
dendlist(dend) \%>\% dendlist(dend2)
dendlist(dend) \%>\% dendlist(dend2) \%>\% dendlist(dend)
dendlist(dend, dend2) \%>\% tanglegram
tanglegram(tree1 = dendlist(dend, dend2))

dend <- iris[1:20, -5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend2 <- iris[1:20, -5] \%>\% dist \%>\% hclust(method = "single") \%>\% as.dendrogram

x <- dendlist(dend, dend2)
plot(x)

}
}

