% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vdem_vci_hci}
\alias{vdem_vci_hci}
\title{Vertical and Horizontal Constraints Indices}
\format{
A data frame with 15040 rows and 6 variables:
\describe{
\item{country_name}{The common country name.}
\item{gwno}{The Gleditsch and Ward numeric country code.}
\item{cowcode}{The Correlates of War numeric country code.}
\item{year}{The year of valid CoW observations.}
\item{hci}{The horizontal constraint index.}
\item{vci}{The vertical constrain index.}
...
}
}
\source{
\doi{10.1093/isq/sqaa076}
}
\usage{
vdem_vci_hci
}
\description{
A dataset of country-year vertical and horizontal constraints as calculated
by Fjelde et al. 2021.
}
\details{
\subsection{Data Source}{

The horizontal and vertical constraints metrics  in this dataset were
developed by Fjelde et al. (2021) in:

Fjelde, H., Knutsen, C. H. & Nygård, H. M. Which Institutions Matter?
Re-Considering the Democratic Civil Peace. \emph{International Studies}
\emph{Quarterly} 65, 223–237 (2021), \doi{10.1093/isq/sqaa076}.

Dataset is available in the supplementary materials \href{https://academic.oup.com/isq/article/65/1/223/5990223}{Replication Package}
}

\subsection{The Indices}{

Horizontal constraints (HCI) represent checks and balances on centralized
executive power. These include constraints put in place by executive and
judicial branches of government. Horizontal constraints mainly serve the
interests of non-governmental elites by protecting their interests against an
uncontrolled executive.

This is in contrast to vertical constraints (VCI), which represent civil
liberties attributed to the general populace that constrain executive
actions. These include suffrage, the presence of elections that appoint
executive officials, freedom of association, freedom of expression, and the
presence of clean and fair elections.
}

\subsection{Methods}{

Both indices were developed from existing variables in the greater V-Dem
data. Although HCI represents a simple arithmetic mean (see
\code{\link[=hci]{hci()}}) of V-Dem's legislative constraints (\code{v2xlg_legcon}) and
judicial constraints variables (\code{v2x_jucon}), the methods behind the VCI are
more complicated.

At it's core, VCI is a multiplicative aggregation of 5 V-Dem variables
designed to measure suffrage, elected officials, freedom of association,
freedom of expression and clean elections, (\code{v2x_suffr}, \code{v2x_accex},
\code{v2x_frassoc_thick}, \code{v2x_freexp_thick}, \code{v2xel_frefair}). However, the final
component (\code{v2xel_frefair}) is a composite index developed with a Bayesian
factor analysis of 8 other V-Dem indicators (\code{v2elembaut}, \code{v2elembcap},
\code{v2elrgstry}, \code{v2elvotbuy}, \code{v2elirreg}, \code{v2elintim}, \code{v2elpeace},
\code{v2elfrfair}), of which, the authors adapted by purging 2 of the components
representing government intimidation or violent actions (\code{v2elintim},
\code{v2elpeace}) to prevent potential endogeneity in their regressions for the
onset of conflict; i.e. you don't want to predict the onset of conflict with
and independent variable that is, in-part, composed of measures of conflict.

Although the original \code{v2xel_frefair} composite index was developed using
V-Dem's \href{https://v-dem.net/static/website/files/wp/wp_21_5th.pdf}{Bayesian Factor Measurement Model},
the VCI adapted for this study took a simpler approach. In footnote 12,
the authors state that the modified composite index was created by averaging
the 6 non-violent indicators of \code{v2xel_frefair} (\code{v2elembaut}, \code{v2elembcap},
\code{v2elrgstry}, \code{v2elvotbuy}, \code{v2elirreg}, \code{v2elfrfair}). Although not
explicitly stated, it's presumed that the average for these 6 indicators was
converted to a 0-1 scale using "...the cumulative distribution function
of the normal distribution". This is the standard V-Dem procedure for their 0-1
interval indices as stated on page 7 of the \href{https://www.v-dem.net/static/website/img/refs/methodologyv111.pdf}{V-Dem V11.1 Methodology}
handbook.

Lastly, the VCI constructed for this manuscript was carried out using the
V-Dem 7.1 dataset. Since that time (current version is V11.1), 2 of the
indicators used in the VCI calculation have been renamed and slightly
altered:
\enumerate{
\item \code{v2x_freexp_thick} was converted to \code{v2x_freexp_altinf} starting with
version 11. The sub-components of this composite index were altered slightly,
but they still encompass the same concepts of censorship in media.
\item \code{v2x_accex} was renamed \code{v2x_elecoff} starting with version 8. This was
due to changes in the aggregation method for calculating the composite index.
Although the conceptual design for the composite indicator has not changed,
the aggregation formula is more complex and consists of 20 indicators
(opposed to 10 for the original \code{v2x_accex}).
}
}
}
\seealso{
\code{\link[=hci]{hci()}}, \code{\link[=vci]{vci()}}
}
\keyword{datasets}
