\name{partition}
\alias{partition}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Finds the partition generated by an evaluation tree}
\description{
Finds the partition generated by an evaluation tree.
An evaluation tree makes a recursive partition of a rectangle.
Functions "eval.cart", "densplit",... return evaluation trees.
}
\usage{
partition(et, grid=TRUE, zerorecs=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{et}{ an evaluation tree;
  output of "eval.cart", "densplit", ...}
 \item{grid}{TRUE or FALSE;
  whether the true coordinates or relative coordinates are used}
 \item{zerorecs}{TRUE or FALSE;
  whether the rectangles where the density vanishes are included;
  (evaluation trees are used by package "delt" to represent 
  density functions)}
}
%\details{}
\value{
 Returns a list with the following elements.
  \item{values }{vector whose lenght is equal to the number of
  rectangles in the partition; value of the function on
  the corresponding rectangle}
  \item{recs}{recnum*(2*d) matrix; recnum is the number of
  rectangles in the partition and d is the dimension of the
  observations. The rows of "recs" describe the rectangles.
  Column (2*j-1) gives the lower value for the j:th interval
  and (2*j):th column gives upper value for the j:th interval,
  j=1,...,d.}
  \item{support}{the rectangle which is partitioned}
}
%\references{ ~put references to the literature/web site here ~ }
\author{ Jussi Klemela }
%\note{ ~~further notes~~ }

%~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{ 
\code{\link{plotparti}},
}

\examples{
library(denpro)
dendat<-sim.data(n=100,seed=5,type="mulmodII")
et<-densplit(dendat)

pa<-partition(et)

plotparti(pa)

}

\keyword{ hplot }%-- one or more ...
