\name{delt-package}
\alias{delt-package}
\alias{delt}
\docType{package}
\title{
Estimation of Multivariate Densities Using Adaptive Partitions
}
\description{
We implement methods for estimating multivariate densities.
We include a discretized kernel estimator,
an adaptive histogram (a greedy histogram and a CART-histogram), 
stagewise minimization, and bootstrap aggregation.
}
\details{
\tabular{ll}{
Package: \tab delt\cr
Version: \tab 0.8.2\cr
Date: \tab 2015-05-17\cr
Depends: \tab R\cr
License: \tab GPL version 2 or newer\cr
URL: \tab http://www.jussiklemela.com/delt\cr
Packaged: \tab Mon Jun 15 16:34:17 2015; jsk\cr
Built: \tab R 3.2.0; i486-pc-linux-gnu; 2015-05-15 16:34:35; unix\cr
}

Greedy histograms:
eval.greedy,
lstseq.greedy.

CART-histograms:
eval.cart,
lstseq.cart.

CART histograms step by step:
densplit,
prune,
eval.pick.

Bootstrap aggregation of histograms:
eval.bagg,
lstseq.bagg.

Stagewise minimization:
eval.stage,
eval.stage.gauss.

Other utilities:
partition,
plotparti.

Tree transformation:
lefrig2par,
makebina.

Miscallenous:
intpcf,
supp.

Index:
\preformatted{
densplit                Calculation of an overfitting histogram
eval.bagg               Returns a bootstrap aggregation of adaptive
                        histograms
eval.cart               Calculates a CART histogram
eval.greedy             Returns a greedy histogram
eval.pick               Returns a subtree of an evaluation tree
eval.stage              Returns a stagewise minimization estimate
eval.stage.gauss        Returns a 1D Gaussian mixture density estimate
intpcf                  Calculates the integral of a piecewise constant
                        function
lefrig2par              Transforms an evaluation tree so that it can be
                        plotted with the "plottree" function of package
                        "denpro"
lstseq.bagg             Calculates a scale of bootstrap aggregated
                        histograms
lstseq.cart             Calculates a scale of CART histograms
lstseq.greedy           Calculates a scale of greedy histograms
makebina                Tranforms and evaluation tree to the tree
                        object of R
partition               Finds the partition generated by an evaluation
                        tree
plotparti               Draws a partition
prune                   Prepares for pruning an overfitting evaluation
                        tree
scaspa                  Finds the number of modes of histograms which
                        are obtained by pruning an overfitting
                        histogram
supp                    Returns the bounding box of observations
}


}
\author{
Jussi Klemela <jussi.klemela@gmail.com>

Maintainer: Jussi Klemela <jussi.klemela@gmail.com>
}
%\references{}
\keyword{ smooth }
%\seealso{~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~ }
\examples{
library(denpro)

# Generate the data

dendat<-sim.data(n=500,seed=5,type="mulmodII")

# Calculate the estimates

eva<-eval.greedy(dendat,leaf=16)

eva<-eval.cart(dendat,leaf=16)

eva<-eval.bagg(dendat,B=3,leaf=12,prune="on")

eva<-eval.stage(dendat,leaf=10,M=3)

# Draw the estimates

lst<-leafsfirst(eva)
plotvolu(lst)

dp<-draw.pcf(eva,pnum=c(60,60))         
persp(dp$x,dp$y,dp$z,theta=-20,phi=30)

}



