% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haplotype_tbl.R
\name{haplotype_tbl}
\alias{haplotype_tbl}
\title{Summarise Haplotypes Down to One Row}
\usage{
haplotype_tbl(dna, clean = TRUE, collapseSubstrings = TRUE, verbose = TRUE)
}
\arguments{
\item{dna}{an object of class \link[ape:DNAbin]{DNAbin}.}

\item{clean}{logical. Whether to remove or not remove non ACTG bases from alignment.}

\item{collapseSubstrings}{logical. Whether to collapse or not collapse shorter but identical sequences.}

\item{verbose}{logical. Returns a warning if any sequence contains non ACTG bases.
See \link{clean_dna} for details.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{haplotype_tbl()} returns a \link[tibble:tbl_df-class]{tbl_df} summarising
all unique haplotype frequencies and duplicates into a single row.
}
\details{
\code{haplotype_tbl()} uses a combination of \link{clean_dna} and \link{hap_collapse} to summarise
haplotypes into a tibble. Each row of the tibble has an unique haplotype,
its frequency and all its collapsed duplicates in a flattened string.
}
\examples{

# get haplotype table
haplotype_tbl(geophagus) 

}
\author{
Rupert A. Collins, Pedro S. Bittencourt.
}
