triang.list <- function (object) 
{
    stopifnot(inherits(object,"deldir"))
    tlist <- triMat(object)
    x <- object$summary[,"x"]
    y <- object$summary[,"y"]
    xtri <- matrix(x[tlist], nrow(tlist), 3)
    ytri <- matrix(y[tlist], nrow(tlist), 3)
    ztri <- ytri - min(y)
    dx <- cbind(xtri[, 2] - xtri[, 1], xtri[, 3] - xtri[, 2], 
        xtri[, 1] - xtri[, 3])
    zm <- cbind(ztri[, 1] + ztri[, 2], ztri[, 2] + ztri[, 3], 
        ztri[, 3] + ztri[, 1])
    negareas <- apply(dx * zm, 1, sum)
    clockwise <- (negareas > 0)
    if (any(clockwise)) {
        xc <- xtri[clockwise,,drop=FALSE]
        yc <- ytri[clockwise,,drop=FALSE]
        xtri[clockwise, ] <- xc[, c(1, 3, 2)]
        ytri[clockwise, ] <- yc[, c(1, 3, 2)]
    }
    rslt <- list()
    K <- 0
    for(i in 1:nrow(xtri)) {
	tmp <- .Fortran(
		"intri",
		x=as.double(xtri[i,]),
		y=as.double(ytri[i,]),
		u=as.double(x),
		v=as.double(y),
		n=as.integer(length(x)),
		okay=logical(1),
		PACKAGE="deldir"
	)
	if(tmp$okay) {
		K <- K+1
		rslt[[K]] <- data.frame(x=xtri[i,],y=ytri[i,])
	}
    }
    attr(rslt,"rw") <- object$rw
    class(rslt) <- "triang.list"
    rslt
}
