% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AWU.R
\name{AWU}
\alias{AWU}
\title{Axial Warping Unit}
\usage{
AWU(r = 50L, dim = 1L, grad = 200, lims = c(-0.5, 0.5), dtype = "float32")
}
\arguments{
\item{r}{number of basis functions}

\item{dim}{dimension to warp}

\item{grad}{steepness of the sigmoid functions}

\item{lims}{the bounded 1D domain on which to set up the sigmoids}

\item{dtype}{data type}
}
\value{
\code{AWU} returns a list containing a list with the following components:
\describe{
 \item{"f"}{An encapsulated function that takes an input and evaluates the sigmoids over the \code{dim}-th dimension using \code{TensorFlow}}
 \item{"fR"}{Same as \code{f} but uses \code{R}}
 \item{"fMC"}{Same as \code{f} but does it in parallel for several inputs index by the first dimension of the tensor}
 \item{"r"}{The number of sigmoid basis functions}
 \item{"trans"}{The transformation applied to the weights before estimation}
 \item{"fix_weights"}{Flag indicating whether the weights are fixed or not (FALSE for AWUs)}
 \item{"name"}{Name of layer}
}
}
\description{
Sets up an axial warping unit (AWU) for used in a deep compositional spatial model. The function
sets up sigmoids on a prescribed domain at regular intervals, with 'steepness' indicated by the user.
It returns a list of length 1 containing an axial warping unit (AWU) and several encapsulated
functions that evaluate the AWU over inputs of different types. See Value for more details.
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
layer <- AWU(r = 50L, dim = 1L, grad = 200, lims = c(-0.5, 0.5))
 }
}
}
