% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.deepMOU.R
\name{plot.deepMOU}
\alias{plot.deepMOU}
\title{Plotting method for "shallow" and deep mixtures of Unigrams and mixtures of Dirichlet-Multinomials}
\usage{
\method{plot}{deepMOU}(
  x,
  y,
  bubble_size = 1,
  bubble_col = c("red", "white"),
  cex_text = 1,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{Output from \code{mou_EM}, \code{dir_mult_GD} or \code{deep_mou_gibbs}.}

\item{y}{Parameter not used}

\item{bubble_size}{Graphical parameter for bubbles size.}

\item{bubble_col}{Choose palette with two colors (default \code{"red"} and \code{"white"}).  The first (darker) color will denote homogeneous clusters, while the latter (lighter) more heterogeneous ones.}

\item{cex_text}{Size of texts inside bubbles.}

\item{main}{A main title for the plot.}

\item{...}{Parameter not used}
}
\value{
A graphical aid to visualize and to describe the obtained clusters.
}
\description{
Bi-dimensional representation (via Multi-Dimensional Scaling) of the clusters, where each bubble corresponds to a cluster,
its size is proportional to the relative frequency of documents and color saturation reflects cluster cohesion.
}
\details{
The default graphical representation of \code{mou_EM}, \code{dir_mult_GD} and \code{deep_mou_gibbs} is the bubble plot.
Namely, a bi-dimensional representation (via Multi-Dimensional Scaling) of the clusters, each bubble corresponds to a cluster,
its size is proportional to the relative frequency of documents and color saturation reflects cluster cohesion.
}
\examples{
# Load the CNAE2 dataset
data("CNAE2")

# Perform parameter estimation and clustering
mou_CNAE2 = mou_EM(x = CNAE2, k = 2)

# Usage of the function
plot(mou_CNAE2, bubble_size = 5 )

}
