% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eb_lambda.R
\name{getShrinkageParams}
\alias{getShrinkageParams}
\title{Estimate shrinkage parameter by empirical Bayes}
\usage{
getShrinkageParams(ecl, k = ecl$k, minimum = 1e-04, lambda = NULL)
}
\arguments{
\item{ecl}{\code{eclairs()} decomposition}

\item{k}{number of singular vectors to use}

\item{minimum}{minimum value of lambda}

\item{lambda}{(default: NULL) If NULL, estimate lambda from data. Else evaluate logML using specified lambda value.}
}
\value{
value \eqn{\lambda} and \eqn{\nu} indicating the shrinkage between sample and prior covariance matrices.
}
\description{
Estimate shrinkage parameter by empirical Bayes
}
\details{
Estimate shrinkage parameter for covariance matrix estimation using empirical Bayes method (Hannart and Naveau, 2014; Leday and Richardson 2019).  The shrinage estimate of the covariance matrix is \eqn{(1-\lambda)\hat\Sigma + \lambda \nu I}, where \eqn{\hat\Sigma} is the sample covariance matrix, given a value of \eqn{\lambda}.  A large value of \eqn{\lambda} indicates more weight on the prior.
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)
rownames(Y) <- paste0("sample_", seq(n))
colnames(Y) <- paste0("gene_", seq(p))

# eclairs decomposition: covariance
ecl <- eclairs(Y, compute = "correlation")

# For full SVD
getShrinkageParams(ecl)

# For truncated SVD at k = 20
getShrinkageParams(ecl, k = 20)

}
\references{
Hannart, A., & Naveau, P. (2014). Estimating high dimensional covariance matrices: A new look at the Gaussian conjugate framework. Journal of Multivariate Analysis, 131, 149-162.

Leday, G. G., & Richardson, S. (2019). Fast Bayesian inference in large Gaussian graphical models. Biometrics, 75(4), 1288-1298.
}
