% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_situations.R
\name{temp_situations}
\alias{temp_situations}
\title{Situation occurrence and resolution}
\usage{
temp_situations(
  n,
  p_occurrence,
  p_resolution,
  normal_outcome = 1,
  situation_outcome = 0,
  var_CV_normal = 0,
  var_CV_situation = 0
)
}
\arguments{
\item{n}{integer; number of values to produce}

\item{p_occurrence}{chance that a situation (e.g. conflict) occurs (probability btw. 0 and 1)}

\item{p_resolution}{chance that the situation disappears
(e.g. the conflict gets resolved) (probability btw. 0 and 1)}

\item{normal_outcome}{output value for vector elements that aren't affected by the 
situation (can be subject to random variation, if var_CV_normal is specified).
Defaults to 1.}

\item{situation_outcome}{output value for vector elements that are affected by the 
situation (can be subject to random variation, if var_CV_situation is specified).
Defaults to 0.}

\item{var_CV_normal}{desired coefficient of variation for 'normal' vector elements (in percent).
Defaults to 0.}

\item{var_CV_situation}{desired coefficient of variation for elements of the vector
that are affected by the situation (in percent). Defaults to 0.}
}
\value{
vector of n numeric values, representing a variable time series, which simulates
the effects of a situation that arises with a probability p_occurrence and disappears again
with a probability p_resolution
}
\description{
This function simulates a situation, e.g. a conflict, that arises with a certain probability,
generates an impact as long as it persists, and has a certain chance of being resolved.
}
\examples{

temp_situations(n=30,p_occurrence=0.2,p_resolution=0.5)

temp_situations(n=30,p_occurrence=0.2,p_resolution=0.5,
normal_outcome=10,situation_outcome=100,var_CV_normal=10,
var_CV_situation=40)

}
\author{
Eike Luedeling
}
\keyword{"temporary}
\keyword{situations"}
\keyword{utility}
