% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{write_wrapper}
\alias{write_wrapper}
\alias{write_wrapper.DNAseq}
\title{A wrapper function to deploy the fastq and fata output functions.}
\usage{
write_wrapper(x, ...)

\method{write_wrapper}{DNAseq}(x, ..., outfile = "denoised.fastq",
  outformat = "fastq", append = TRUE, keep_phred = TRUE,
  phred_placeholder = "#")
}
\arguments{
\item{x}{a DNAseq class object.}

\item{...}{additional arguments to be passed between methods.}

\item{outfile}{The name of the file to output the data to. Default is "denoised.fasta".}

\item{outformat}{The format of the output data, either fasta for fastq. Default is fastq.}

\item{append}{Should the ccs consensus sequence be appended to the output file?(TRUE) 
Or overwrite the file?(FALSE) Default is TRUE.}

\item{keep_phred}{Should the original PHRED scores be kept in the output? Default is TRUE.}

\item{phred_placeholder}{The character to input for the phred score line. Default is '#'.}
}
\value{
a class object of code{"DNAseq"}
}
\description{
A wrapper function to deploy the fastq and fata output functions.
}
\keyword{internal}
