\name{deamer-package}
%\alias{deamer-package}
\alias{deamer}
\docType{package}

\title{
Non-parametric deconvolution density estimation of variables prone to measurement-error.
}
\description{
The \code{deamer} package provides routines for non-parametric estimation of the 
density \eqn{f} of a variable with additive noise \eqn{e}. The general error model is \eqn{y=x+e},
where \eqn{y} is the noisy observation, \eqn{x} is the unobserved variable and \eqn{e} is a measurement error.\cr 

Technically, the estimation is performed using penalized deconvolution contrasts and data-driven adaptive model-selection. 
The estimator is projected on an orthonormal sinus cardinal basis using Fast Fourrier Transform for efficiency.\cr
This technical framework is implemented for three situations depending on the available 
information or data regarding the noise \eqn{e}. It is assumed in all cases that 
the noise is homoscedastic and that its charateristic function never vanishes.\cr
Each situation is encapsulated in a specific function: 

\enumerate{
\item \code{\link{deamerKE}} for estimation with known error density. The density of the error is assumed 
      Gaussian or Laplace with a known mean and standard deviation (Gaussian) or scale parameter (Laplace).  
\item \code{\link{deamerSE}} for estimation with an auxiliary sample of errors. This situation arises when the density 
       of \eqn{e} is unknown, but an auxiliary sample of independent and identically distributed pure errors is available.
       Examples of such situations are found in engineering for example, when errors can be freely generated by a controlled system (like a measuring device).  
\item \code{\link{deamerRO}} for estimation with an auxiliary sample of replicate observations (see \code{\link{deamerRO}} for a formal definition of replicate observations).
      Here, the density of the noise is specifically assumed symmetric around zero.
      This situation is likely to arise in biological and medical research, when pure errors cannot be observed but 
      replicate (or repeated) noisy observations can be achieved in a sample of individuals.
}

Each of these functions will produce an object of class \code{deamer} for which generic methods exist.
Alternatively, estimation can also be conducted using the default function \code{deamer} for users familiar with all three situations by specifying
an argument \code{'method'} and the appropriate arguments (see \code{\link{deamer-class}} and the example within).\cr
It is worth mentionning that unlike any other deconvolution procedure, \code{deamer} does 
not require an estimation of a "bandwidth" parameter prior to density estimation, 
thus making the usage much easier.
Furthermore, \code{deamerKE} and \code{deamerSE} directly handle non-centered noise.\cr
However, none of the \code{deamer} functions are implemented for heteroscedastic errors.

}

\details{
\tabular{ll}{
Package: \tab deamer\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-06-29\cr
License: \tab GPL\cr
}}

\author{
Julien Stirnemann, Adeline Samson, Fabienne Comte with contribution from Claire Lacour.

Maintainer: Julien Stirnemann <j.stirnemann@gmail.com>
}

\references{
\cite{Stirnemann JJ, Comte F, Samson A. Density estimation of a biomedical variable
      subject to measurement error using an auxiliary set of replicate observations.
      Statistics in medicine. 2012 May 17 [Epub ahead of print]}\cr
      
\cite{Comte F, Lacour C. Data-driven density estimation in the presence of additive
      noise with unknown distribution. Journal of the Royal Statistical Society:
      Series B (Statistical Methodology). 2011 Sep 1;73(4):601-27.}\cr

\cite{Comte F, Rozenholc Y, Taupin M-L. Penalized Contrast Estimator for Adaptive
      Density Deconvolution. The Canadian Journal of Statistics /
      La Revue Canadienne de Statistique. 2006; 34(3):431-52.}\cr

\cite{Comte F, Samson A, Stirnemann J. Deconvolution estimation of onset of pregnancy
      with replicate observations [Internet]. 2011 [cited 2011 Oct 25].
      Available from: http://hal.archives-ouvertes.fr/hal-00588235_v2/}\cr

}

\seealso{
\code{\link{deamer-class}},
\code{\link{deamerKE}},
\code{\link{deamerSE}},
\code{\link{deamerRO}}}

\keyword{package}
