% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/malmquist_index.R
\name{malmquist_index}
\alias{malmquist_index}
\title{Malmquist index}
\usage{
malmquist_index(datadealist,
                       dmu_eval = NULL,
                       dmu_ref = NULL,
                       orientation = c("io", "oo"))
}
\arguments{
\item{datadealist}{A list with the data at different times, including DMUs, inputs and outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.}

\item{orientation}{A string, equal to "io" (input oriented) or "oo" (output oriented).}
}
\value{
A numeric list with Malmquist index and efficiencies.
}
\description{
This function calculates the conventional input/output oriented Malmquist index under constant and variables returns-to-scale.
}
\note{
In the results: EC=Efficiency Change, PTEC=Pure Technical Efficiency Change, SEC=Scale Efficiency Change, TC= Technological Change, MI= Malmquist Index
}
\examples{
# Example 1. With dataset in wide format.
# Replication of results in Wang and Lan (2011, p. 2768)
data("Economy")
data_example <- read_malmquist(datadea = Economy,
                               nper = 5, 
                               arrangement = "horizontal",
                               ni = 2, 
                               no = 1)
result <- malmquist_index(data_example, orientation = "io")
mi <- result$mi
effch <- result$ec
tech <- result$tc

# Example 2. With dataset in long format.
# Replication of results in Wang and Lan (2011, p. 2768)
data("EconomyLong")
data_example2 <- read_malmquist(EconomyLong,
                                percol = 2, 
                                arrangement = "vertical",
                                inputs = 3:4, 
                                outputs = 5)
result2 <- malmquist_index(data_example2, orientation = "io")
mi2 <- result2$mi
effch2 <- result2$ec
tech2 <- result2$tc

}
\references{
Caves, D.W.; Christensen, L. R. y Diewert, W.E. (1982). “The Economic Theory of Index Numbers and the Measurement of Input, Output, and Productivity”. Econometrica, 50(6), 1393-1414. 
 
Färe, R.; Grosskopf, S.; Lindgren, B.; Roos, P. (1989). “Productivity Developments in Swedish Hospitals: A Malmquist Output Index Approach”. Discussion paper nº 89-3. Southern Illinois University. Illinois.

Färe, R.; Grosskopf, S.; Lindgren, B.; Roos, P. (1992). “Productivity changes in Swedish Pharmacies 1980-89: A nonparametric Malmquist Approach”. Journal of productivity Analysis, 3(3), 85-101. 

Färe, R.; Grosskopf, S.; Norris, M. y Zhang, Z. (1994). “Productivity Growth, Technical Progress, and Efficiency Change in Industrialized Countries”. American Economic Review, 84(1), 66-83.
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
