% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{liver.toxicity}
\alias{liver.toxicity}
\title{Data set of Liver Toxicity Data, from \emph{mixOmics}}
\format{A list containing the following components:
\describe{
  \item{gene}{data frame with \eqn{64} rows and \eqn{3116} columns. The
  expression measure of 3116 genes for the \eqn{64} subjects (rats).}
  \item{clinic}{weight of the diamond, in carats.}
  \item{treatment}{data frame with \eqn{64} rows and \eqn{4} columns,
  containing the treatment information on the \eqn{64} subjects, such as doses of
  acetaminophen
   and times of necropsies.}
 \item{gene.ID}{data frame with \eqn{3116} rows and \eqn{2} columns,
   containing geneBank IDs and gene titles of the annotated genes.}
}}
\source{
The liver toxicity dataset has been downloaded from the \strong{mixOmics} package.
\url{http://mixomics.org/methods/pls-da/}.
}
\usage{
liver.toxicity
}
\description{
This data set contains the expression measure of \eqn{3116} genes
and \eqn{10} clinical measurements for \eqn{64} subjects (rats) that
 were exposed to non-toxic, moderately toxic or severely toxic doses
  of acetaminophen in a controlled experiment.
}
\details{
The data come from a liver toxicity study (Bushel \emph{et al.}, 2007) in
  which 64 male rats of the inbred strain Fisher 344 were exposed to
  non-toxic (50 or 150 mg/kg), moderately toxic (1500 mg/kg) or severely
  toxic (2000 mg/kg) doses of acetaminophen (paracetamol) in a controlled
  experiment. Necropsies were performed at 6, 18, 24 and 48 hours after
  exposure and the mRNA from the liver was extracted. Ten clinical chemistry
   measurements of variables containing markers for liver injury are available
    for each subject and the serum enzymes levels are measured numerically.
     The data were further normalized and pre-processed by Bushel \emph{et al.} (2007).
}
\references{
{
  \insertRef{bushel2007simultaneous}{ddsPLS}
}
}
\keyword{datasets}
