% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddml_fpliv.R, R/ddml_pliv.R, R/ddml_plm.R
\name{print.summary.ddml_fpliv}
\alias{print.summary.ddml_fpliv}
\alias{print.summary.ddml_pliv}
\alias{print.summary.ddml_plm}
\title{Print Methods for Treatment Effect Estimators.}
\usage{
\method{print}{summary.ddml_fpliv}(x, digits = 3, ...)

\method{print}{summary.ddml_pliv}(x, digits = 3, ...)

\method{print}{summary.ddml_plm}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{summary.ddml_plm},
\code{summary.ddml_pliv}, and \code{summary.ddml_fpliv}, as
returned by \code{\link[=summary.ddml_plm]{summary.ddml_plm()}}, \code{\link[=summary.ddml_pliv]{summary.ddml_pliv()}},
and \code{\link[=summary.ddml_fpliv]{summary.ddml_fpliv()}}, respectively.}

\item{digits}{Number of significant digits used for priniting.}

\item{...}{Currently unused.}
}
\value{
NULL.
}
\description{
Inference methods for treatment effect estimators.
}
\examples{
# Construct variables from the included Angrist & Evans (1998) data
y = AE98[, "worked"]
D = AE98[, "morekids"]
X = AE98[, c("age","agefst","black","hisp","othrace","educ")]

# Estimate the partially linear model using a single base learner, ridge.
plm_fit <- ddml_plm(y, D, X,
                    learners = list(what = mdl_glmnet,
                                    args = list(alpha = 0)),
                    sample_folds = 2,
                    silent = TRUE)
summary(plm_fit)
}
