% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dda_indep.r
\name{dda.indep}
\alias{dda.indep}
\alias{print.dda.indep}
\title{Direction Dependence Analysis: Independence Properties}
\usage{
dda.indep(
  formula,
  pred = NULL,
  data = list(),
  nlfun = NULL,
  hetero = FALSE,
  hsic.method = "gamma",
  diff = FALSE,
  B = 200,
  boot.type = "perc",
  conf.level = 0.95,
  parallelize = FALSE,
  cores = 1
)

\method{print}{dda.indep}(x, ...)
}
\arguments{
\item{formula}{Symbolic formula of the model to be tested or a \code{lm} object.}

\item{pred}{A character indicating the variable name of the predictor which serves as the outcome in the alternative model.}

\item{data}{An optional data frame containing the variables in the model (by default variables are taken from the environment which \code{dda.indep} is called from).}

\item{nlfun}{Either a numeric value or a function of .Primitive type used for non-linear correlation tests. When \code{nlfun} is numeric the value is used in a power transformation.}

\item{hetero}{A logical value indicating whether separate homoscedasticity tests (i.e., standard and robust Breusch-Pagan tests) should be computed.}

\item{hsic.method}{A character indicating the inference method for the Hilbert-Schmidt Independence Criterion (HSIC). Must be one of the four specifications \code{c("gamma", "eigenvalue", "boot", "permutation")}. \code{hsic.method = "gamma"}is the default.}

\item{diff}{A logical value indicating whether differences in HSIC, Distance Correlation (dCor), and MI values should be computed. Bootstrap confidence intervals are computed using B bootstrap samples.}

\item{B}{Number of permutations for separate dCor tests and number of resamples if \code{hsic.method = c("boot", "permutation")} or \code{diff = TRUE}.}

\item{boot.type}{A vector of character strings representing the type of bootstrap confidence intervals. Must be one of the two specifications \code{c("perc", "bca")}.\code{boot.type = "perc"} is the default.}

\item{conf.level}{Confidence level for bootstrap confidence intervals.}

\item{parallelize}{A logical value indicating whether bootstrapping is performed on multiple cores. Only used if \code{diff = TRUE}.}

\item{cores}{A numeric value indicating the number of cores. Only used if \code{parallelize = TRUE}.}

\item{x}{An object of class \code{dda.indep} when using \code{print}.}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
An object of class \code{dda.indep} containing the results of DDA independence tests.
}
\description{
\code{dda.indep} computes DDA test statistics to
             evaluate asymmetries of predictor-error independence of
             causally competing models (\code{y ~ x} vs. \code{x ~ y}).

\code{print} returns DDA test statistics associated with \code{dda.indep} objects.
}
\examples{

set.seed(123)
n <- 500
x <- rchisq(n, df = 4) - 4
e <- rchisq(n, df = 3) - 3
y <- 0.5 * x + e
d <- data.frame(x, y)

result <- dda.indep(y ~ x, pred = "x", data = d, parallelize = TRUE, cores = 2,
          nlfun = 2, B = 50, hetero = TRUE, diff = TRUE)


print(result)

}
\references{
Wiedermann, W., & von Eye, A. (2025). \emph{Direction Dependence Analysis: Foundations and Statistical Methods}. Cambridge, UK: Cambridge University Press.
}
\seealso{
\code{\link{cdda.indep}} for a conditional version.
}
