test_that("LOF", {
  set.seed(665544)
  n <- 600
  x <- cbind(
    x=runif(10, 0, 5) + rnorm(n, sd=0.4),
    y=runif(10, 0, 5) + rnorm(n, sd=0.4)
  )

  ### calculate LOF score
  system.time(lof_kd <- lof(x, minPts = 5))
  expect_length(lof_kd, nrow(x))

  system.time(lof_d <- lof(dist(x), minPts = 5))
  #expect_equal(lof_kd, lof_d)

  ## compare with lofactor from DMwR (k = minPts - 1)
  #if(requireNamespace("DMwR", quietly = TRUE)) {
  #  system.time(lof_DMwr <- DMwR::lofactor(x, k = 4))
  # DMwR is now retired so we have the correct values here
  #  dput(round(lof_DMwr, 7))

  lof_DMwr <- c(1.0386817, 1.0725475, 1.1440822, 0.9448794, 1.1387918, 2.285202,
    1.0976862, 1.071325, 0.975922, 0.9549399, 1.0918247, 0.9868736,
    1.123618, 2.2802129, 0.992019, 1.046492, 1.0729966, 1.6925297,
    1.0032157, 0.9691323, 1.0561082, 0.9493052, 1.0209116, 0.8897277,
    1.008681, 1.0711202, 1.053845, 0.9734241, 1.1147289, 0.9351913,
    1.8674401, 1.097982, 0.9782695, 1.0613472, 0.9988367, 1.4571062,
    0.9927837, 0.9443716, 1.0014804, 1.0322888, 0.9264795, 0.9509729,
    0.9757305, 1.0647956, 1.0184634, 1.428911, 1.0166712, 0.9692196,
    1.0821285, 1.1282936, 0.9874694, 1.1079347, 0.9906487, 0.9972962,
    1.0594364, 0.9160978, 1.2393862, 1.3578505, 0.930095, 1.0489962,
    1.1401282, 1.1808566, 1.0380796, 2.0657157, 0.9837392, 0.9712287,
    1.4754447, 1.3154291, 1.0589814, 1.0486608, 1.0986178, 1.1375705,
    1.0147473, 1.7615974, 0.9724805, 0.9719851, 0.982247, 1.0591561,
    1.0862436, 1.0710844, 1.11301, 0.9719126, 1.0455651, 0.9426225,
    1.0934785, 1.1223749, 1.1734774, 1.0037237, 0.8844162, 0.9131705,
    1.0728687, 1.0446755, 1.108353, 0.9492501, 1.1704727, 1.1914106,
    0.9453222, 1.1724001, 1.1827576, 0.9617445, 1.1519398, 1.1480532,
    1.0268692, 1.0580088, 1.392551, 1.2571354, 0.9703385, 1.5030845,
    1.0201881, 1.0061842, 0.9919245, 1.2771078, 1.0473407, 1.263149,
    0.9587146, 1.0235194, 0.988292, 0.9302287, 1.0593181, 0.978052,
    1.1026427, 1.0615622, 1.0299466, 1.2200394, 1.0720229, 1.1343499,
    1.0180289, 1.4500258, 0.9886391, 0.969401, 1.4881191, 1.0775279,
    1.0380796, 1.2315327, 1.0307432, 0.9615078, 1.2379828, 1.1181202,
    1.1049541, 1.0786524, 0.9197587, 1.0642223, 0.8073981, 0.9251505,
    0.9971381, 1.5188771, 1.0679818, 0.9943418, 3.5343815, 0.9559526,
    1.2129819, 1.0067672, 1.0175442, 1.0875222, 1.0403766, 2.0998678,
    0.9870077, 1.327542, 1.0081014, 0.9608997, 0.9144311, 1.0016777,
    1.0465469, 1.5140562, 1.5560253, 1.1125134, 1.0310594, 1.0245521,
    1.7247798, 1.0586581, 1.0720232, 1.0594747, 0.956174, 1.0540952,
    1.0889792, 1.050014, 1.0216425, 0.9509729, 0.9740812, 1.3065791,
    1.0004211, 1.0127932, 0.9796374, 1.0552426, 1.0302613, 0.9524017,
    0.9554341, 0.9870971, 0.9857225, 0.9699046, 1.1122461, 1.031985,
    1.0852427, 1.0585017, 0.9733342, 0.9610561, 0.9086219, 1.1570747,
    1.069232, 0.9747538, 1.0084392, 1.1063077, 0.9573789, 1.3672764,
    1.3631144, 0.966934, 1.0992401, 0.9943351, 0.9850424, 1.0019623,
    1.5344698, 0.9592966, 0.9645661, 1.0076189, 1.0056102, 1.0066028,
    1.0148453, 1.0096178, 1.0963682, 1.0345623, 1.0121158, 1.0816582,
    1.0068326, 0.9697611, 0.9322887, 1.1414811, 1.0266256, 0.9143263,
    0.9602328, 1.1100272, 1.0885216, 1.0795966, 1.1165265, 1.1712866,
    1.1478981, 0.9653769, 1.0419996, 1.0245088, 1.0619264, 1.1729143,
    0.9756447, 0.9935498, 2.8554242, 1.0067806, 1.1311249, 1.36881,
    1.8759446, 1.2136268, 1.2112035, 0.9891436, 1.1089825, 0.9937973,
    0.9730926, 1.0287588, 1.1275406, 1.5135599, 1.0322888, 1.0746697,
    1.0181387, 1.2715467, 0.9196022, 1.1063077, 1.0666201, 1.121323,
    1.0850662, 0.9150997, 1.428667, 0.9488952, 1.1007532, 1.2246563,
    0.9933742, 1.1263888, 0.985569, 1.0275125, 1.01964, 1.0449989,
    0.9767297, 0.9704362, 0.9897834, 1.0246062, 1.0947694, 1.2170169,
    1.1323645, 1.2366689, 0.9516316, 1.2727108, 1.0480459, 1.0338822,
    1.1418884, 1.0733666, 1.0230934, 0.9149864, 0.9480381, 1.0388333,
    1.1266161, 0.9615078, 1.1221968, 0.9750836, 0.978132, 1.1412698,
    0.9716957, 1.0675609, 1.2594503, 1.0633289, 1.1427586, 1.0709402,
    1.0393154, 1.3284915, 0.9598698, 1.1755224, 1.2392279, 1.0625965,
    1.133851, 1.1631179, 1.4499444, 1.20366, 0.9606104, 0.9921343,
    0.8938437, 1.1738624, 1.0131062, 1.0027174, 0.9461069, 0.9717685,
    1.0645426, 1.046492, 1.1502628, 0.999057, 0.9758641, 1.1654844,
    0.9964193, 1.1066967, 1.1900241, 1.0727625, 1.1304909, 1.0892065,
    0.963785, 1.2942228, 1.0619264, 1.2733898, 0.9840458, 1.109005,
    1.0437884, 1.0298398, 0.9513221, 1.0823791, 1.0056102, 0.8875967,
    1.1385844, 0.8947159, 1.229025, 2.0563263, 0.9387754, 0.9683886,
    1.2059569, 0.9923111, 1.4218394, 1.043666, 0.9963639, 1.0610107,
    1.0049425, 0.9844978, 1.0292947, 0.9768325, 1.0528094, 1.0155664,
    1.1586381, 1.0432875, 1.0382743, 0.9793557, 1.1206471, 0.985182,
    1.1138052, 1.3397872, 1.0062782, 0.9474922, 1.2033802, 1.0889565,
    0.9172793, 0.9749791, 0.9912765, 1.2617741, 0.9875289, 0.9231973,
    1.1543416, 1.084554, 0.9805775, 0.9976991, 1.0076805, 1.0267488,
    0.9919245, 1.0627179, 0.9760528, 1.14714, 0.947823, 1.0574966,
    1.0560581, 0.9939038, 1.1754719, 0.9804448, 1.1892616, 1.2926922,
    1.0381062, 0.9991459, 1.0110192, 1.7982637, 0.9932575, 1.0365072,
    1.0476382, 0.9572147, 1.0362918, 0.929587, 1.1575934, 1.0942486,
    1.1386353, 1.0484103, 1.0846261, 0.9627105, 1.0514676, 1.0148971,
    0.9468566, 1.1103724, 1.0637948, 1.9343892, 1.0520743, 1.0526934,
    1.0679818, 1.0045373, 1.3400328, 0.9598806, 1.0309374, 0.9556979,
    1.3586868, 0.9806832, 1.0108765, 0.9652751, 1.9171728, 1.1786559,
    1.0223136, 0.9491173, 1.0020994, 0.977787, 1.0659739, 1.4374944,
    1.0311553, 1.0109194, 1.4310709, 0.9937973, 1.1235442, 1.0475279,
    1.0221015, 1.0810464, 1.6977976, 1.0944615, 1.0511645, 1.0957941,
    1.4443457, 1.0375637, 1.1045543, 1.0264414, 1.0205876, 1.3753965,
    1.0976175, 1.0539255, 1.037731, 1.0592793, 1.0109924, 1.0427939,
    1.1111455, 1.04521, 0.9745986, 1.3716186, 1.0089931, 1.0603559,
    1.5494147, 0.9854366, 1.2662523, 0.9623836, 1.3929899, 0.999679,
    1.0011268, 1.0179427, 1.0416134, 1.7609114, 1.069779, 1.0366241,
    1.1245068, 0.9792311, 0.967655, 0.9542575, 1.1684304, 1.2482993,
    1.2640331, 1.0298585, 0.9111223, 1.0672941, 0.9855631, 0.9206366,
    1.1058931, 1.0740426, 0.9649612, 1.3460875, 0.9493052, 1.0763382,
    1.0750445, 1.1003632, 1.0639591, 1.0930897, 0.9366367, 1.4825478,
    0.9872073, 1.0595017, 0.9098508, 0.9132522, 0.9715029, 1.3445599,
    0.9442429, 0.9947035, 1.5735628, 1.0179848, 1.1207158, 1.4513845,
    0.9971349, 1.0549698, 1.0829184, 0.9570918, 1.1063325, 1.049832,
    1.6941119, 0.976464, 1.0548108, 1.0429154, 1.1387078, 1.252386,
    1.4497295, 1.2952889, 1.0345598, 1.3188744, 1.059327, 0.9671478,
    0.9628657, 0.9935354, 1.2020615, 0.977946, 1.0286028, 0.9360817,
    0.9507702, 1.0119649, 1.49294, 0.9929636, 1.0500374, 1.3857874,
    1.271137, 1.2183431, 1.0284245, 1.2371945, 1.1308861, 1.386502,
    1.0364896, 1.222194, 1.0893758, 1.3687506, 0.9889728, 0.9717685,
    0.9804448, 1.0066674, 0.9703385, 1.5495994, 1.0779985, 0.9233493,
    1.1049508, 1.0770304, 0.9206519, 1.645557, 1.0494959, 1.1984923,
    1.4967244, 0.9976991, 1.0476285, 0.9612643, 0.9270878, 0.9683637,
    1.1585881, 1.0376168, 0.9816509, 0.9598896, 1.035713, 1.0170878,
    0.9578521, 0.9849839, 0.9363952, 0.9856201, 1.0240401, 1.1739687,
    1.1257174, 0.9772498, 0.9539389, 0.9537187, 1.3452872, 0.9888146
  )

  expect_equal(round(lof_kd, 7), lof_DMwr)
  expect_equal(round(lof_d, 7), lof_DMwr)

  ## missing values, but distances are fine
  x_na <- x
  x_na[c(1,3,5), 1] <- NA
  expect_error(lof(x_na), regexp = "NA")
  res_d1 <- lof(x_na, search = "dist")
  res_d2 <- lof(dist(x_na))
  expect_equal(res_d1, res_d2)

  x_na[c(1,3,5), 2] <- NA
  expect_error(lof(x_na), regexp = "NA")
  expect_error(lof(x_na, search = "dist"),
    regexp = "NA")
  expect_error(lof(dist(x_na)), regexp = "NA")

  ## test with tied distances
  x <- rbind(1,2,3,4,5,6,7)
  expect_equal(round(lof(x, minPts = 4), 7),
    c(1.0679012, 1.0679012, 1.0133929, 0.8730159, 1.0133929, 1.0679012, 1.0679012))

  expect_equal(round(lof(dist(x), minPts = 4),7),
    c(1.0679012, 1.0679012, 1.0133929, 0.8730159, 1.0133929, 1.0679012, 1.0679012))
})
