% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyeval.R
\name{partial_eval}
\alias{partial_eval}
\title{Partially evaluate an expression.}
\usage{
partial_eval(call, data, env = caller_env(), vars = NULL, error_call)
}
\arguments{
\item{call}{an unevaluated expression, as produced by \code{\link[=quote]{quote()}}}

\item{data}{A lazy data frame backed by a database query.}

\item{env}{environment in which to search for local values}

\item{vars}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: Pass a lazy frame to \code{data}
instead.}
}
\description{
This function partially evaluates an expression, using information from
the tbl to determine whether names refer to local expressions
or remote variables. This simplifies SQL translation because expressions
don't need to carry around their environment - all relevant information
is incorporated into the expression.
}
\section{Symbol substitution}{


\code{partial_eval()} needs to guess if you're referring to a variable on the
server (remote), or in the current environment (local). It's not possible to
do this 100\% perfectly. \code{partial_eval()} uses the following heuristic:

\itemize{
\item If the tbl variables are known, and the symbol matches a tbl
variable, then remote.
\item If the symbol is defined locally, local.
\item Otherwise, remote.
}

You can override the guesses using \code{local()} and \code{remote()} to force
computation, or by using the \code{.data} and \code{.env} pronouns of tidy evaluation.
}

\examples{
lf <- lazy_frame(year = 1980, id = 1)
partial_eval(quote(year > 1980), data = lf)

ids <- c("ansonca01", "forceda01", "mathebo01")
partial_eval(quote(id \%in\% ids), lf)

# cf.
partial_eval(quote(id == .data$id), lf)

# You can use local() or .env to disambiguate between local and remote
# variables: otherwise remote is always preferred
year <- 1980
partial_eval(quote(year > year), lf)
partial_eval(quote(year > local(year)), lf)
partial_eval(quote(year > .env$year), lf)

# Functions are always assumed to be remote. Use local to force evaluation
# in R.
f <- function(x) x + 1
partial_eval(quote(year > f(1980)), lf)
partial_eval(quote(year > local(f(1980))), lf)
}
\keyword{internal}
