% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_transporter_node_parser.R
\name{transporters_textbooks}
\alias{transporters_textbooks}
\title{Extracts the drug transporters textbooks element and return data as
 tibble.}
\usage{
transporters_textbooks(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}

\item{save_csv}{boolean, save csv version of parsed tibble if true}

\item{csv_path}{location to save csv files into it, default is current
location, save_csv must be true}

\item{override_csv}{override existing csv, if any, in case it is true in the
new parse operation}

\item{database_connection}{DBI connection object that holds a connection to
user defined database. If \code{save_table} is enabled without providing
value for this function an error will be thrown.}
}
\value{
drug transporters textbooks node attributes date frame
}
\description{
\code{transporters_textbooks} returns tibble of drug
transporters
 textbooks elements.
}
\details{
This functions extracts the transporters textbooks element of drug node in
drugbank
xml database with the option to save it in a predefined database via
passed database connection. It takes two optional arguments to
save the returned tibble in the database \code{save_table} and
\code{database_connection}.
It must be called after \code{\link{read_drugbank_xml_db}} function like
any other parser function.
If \code{\link{read_drugbank_xml_db}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\dontrun{
# return only the parsed tibble
transporters_textbooks()

# will throw an error, as database_connection is NULL
transporters_textbooks(save_table = TRUE)

# save in database in SQLite in memory database and return parsed tibble
sqlite_con <- DBI::dbConnect(RSQLite::SQLite())
transporters_textbooks(save_table = TRUE, database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in current
# location and return parsed tibble.
# If the csv exist before read it and return its data.
transporters_textbooks(save_csv = TRUE)

# save in database, save parsed tibble as csv if it does not exist
# in current location and return parsed tibble.
# If the csv exist before read it and return its data.
transporters_textbooks(save_table = TRUE, save_csv = TRUE)

# save parsed tibble as csv if it does not exist in given location
#  and return parsed tibble.
# If the csv exist before read it and return its data.
transporters_textbooks(save_csv = TRUE, csv_path = TRUE)

# save parsed tibble as csv if it does not exist in current
# location and return parsed tibble.
# If the csv exist override it and return it.
transporters_textbooks(
  save_csv = TRUE, csv_path = TRUE,
  override = TRUE
)
}
}
\seealso{
Other transporters: 
\code{\link{transporters_actions}()},
\code{\link{transporters_articles}()},
\code{\link{transporters_links}()},
\code{\link{transporters_polypep_ex_ident}()},
\code{\link{transporters_polypeptide_go}()},
\code{\link{transporters_polypeptide_pfams}()},
\code{\link{transporters_polypeptide_syn}()},
\code{\link{transporters_polypeptide}()},
\code{\link{transporters}()}
}
\concept{transporters}
