% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI_methods.R
\docType{methods}
\name{dbExecute,dbi.catalog,SQL-method}
\alias{dbExecute,dbi.catalog,SQL-method}
\alias{dbExecute,dbi.schema,SQL-method}
\alias{dbExecute,dbi.table,SQL-method}
\alias{dbSendStatement,dbi.table,missing-method}
\alias{dbGetInfo,dbi.catalog-method}
\alias{dbGetInfo,dbi.table}
\alias{dbGetInfo,dbi.schema-method}
\alias{dbGetInfo,dbi.table-method}
\title{DBI Methods for \code{dbi.table}s}
\usage{
\S4method{dbExecute}{dbi.catalog,SQL}(conn, statement, ...)

\S4method{dbExecute}{dbi.schema,SQL}(conn, statement, ...)

\S4method{dbExecute}{dbi.table,SQL}(conn, statement, ...)

\S4method{dbSendStatement}{dbi.table,missing}(
  conn,
  statement,
  ...,
  n = getOption("dbi_table_max_fetch", 10000L)
)

\S4method{dbGetInfo}{dbi.catalog}(dbObj, ...)

\S4method{dbGetInfo}{dbi.schema}(dbObj, ...)

\S4method{dbGetInfo}{dbi.table}(dbObj, ...)
}
\arguments{
\item{conn}{a \code{\link{dbi.catalog}}, \code{dbi.schema}, or \code{\link{dbi.table}}.}

\item{statement}{a \code{\link[DBI]{SQL}} object.}

\item{...}{other parameters passed on to methods.}

\item{n}{an integer value. A nonnegative value limits the number of records returned
by the query. A negative value omits the LIMIT (or TOP) clause entirely.}

\item{dbObj}{a \code{\link{dbi.catalog}}, \code{dbi.schema}, or \code{\link{dbi.table}}.}
}
\description{
Call DBI methods using the underlying DBI connection.
}
\seealso{
\code{\link[DBI]{dbExecute}}, \code{\link[DBI]{dbGetInfo}},
  \code{\link[DBI]{dbSendStatement}}
}
