% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_check.R
\name{row_check}
\alias{row_check}
\title{Row Check}
\usage{
row_check(DS.data, verbose = TRUE)
}
\arguments{
\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as the row numbers of any problematic rows.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (A list of problematic row and participant ID numbers).
}
\description{
This function checks for empty or duplicate rows in the data set.
}
\examples{
# Example 1: Fail check
data(ExampleK)
row_check(DS.data.K)
print(row_check(DS.data.K, verbose=FALSE))

# Example 2: Pass check
data(ExampleC)
row_check(DS.data.C)
print(row_check(DS.data.C, verbose=FALSE))
}
