% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getset.r
\name{getters}
\alias{getters}
\alias{get_year.datetimeoffset}
\alias{get_month.datetimeoffset}
\alias{get_day.datetimeoffset}
\alias{get_hour.datetimeoffset}
\alias{get_minute.datetimeoffset}
\alias{get_second.datetimeoffset}
\alias{get_nanosecond.datetimeoffset}
\alias{get_subsecond_digits}
\alias{get_subsecond_digits.datetimeoffset}
\alias{get_subsecond_digits.default}
\alias{get_hour_offset}
\alias{get_hour_offset.datetimeoffset}
\alias{get_hour_offset.default}
\alias{get_hour_offset.POSIXt}
\alias{get_minute_offset}
\alias{get_minute_offset.datetimeoffset}
\alias{get_minute_offset.default}
\alias{get_minute_offset.POSIXt}
\alias{get_tz}
\alias{get_tz.datetimeoffset}
\alias{get_tz.POSIXt}
\alias{get_tz.clock_zoned_time}
\alias{get_tz.default}
\title{Get datetime components}
\usage{
\method{get_year}{datetimeoffset}(x)

\method{get_month}{datetimeoffset}(x)

\method{get_day}{datetimeoffset}(x)

\method{get_hour}{datetimeoffset}(x)

\method{get_minute}{datetimeoffset}(x)

\method{get_second}{datetimeoffset}(x)

\method{get_nanosecond}{datetimeoffset}(x)

get_subsecond_digits(x)

\method{get_subsecond_digits}{datetimeoffset}(x)

\method{get_subsecond_digits}{default}(x)

get_hour_offset(x)

\method{get_hour_offset}{datetimeoffset}(x)

\method{get_hour_offset}{default}(x)

\method{get_hour_offset}{POSIXt}(x)

get_minute_offset(x)

\method{get_minute_offset}{datetimeoffset}(x)

\method{get_minute_offset}{default}(x)

\method{get_minute_offset}{POSIXt}(x)

get_tz(x)

\method{get_tz}{datetimeoffset}(x)

\method{get_tz}{POSIXt}(x)

\method{get_tz}{clock_zoned_time}(x)

\method{get_tz}{default}(x)
}
\arguments{
\item{x}{A datetime object.}
}
\value{
The component
}
\description{
Getter methods for \code{\link[=datetimeoffset]{datetimeoffset()}} objects.
}
\details{
We implement \code{\link[=datetimeoffset]{datetimeoffset()}} support for the following S3 methods from \code{clock}:
\itemize{
\item \code{get_year()}
\item \code{get_month()}
\item \code{get_day()}
\item \code{get_hour()}
\item \code{get_minute()}
\item \code{get_second()}
\item \code{get_nanosecond()}
}

We also implemented new S3 getter methods:
\itemize{
\item \code{get_subsecond_digits()}
\item \code{get_hour_offset()}
\item \code{get_minute_offset()}
\item \code{get_tz()}
}

We also implement \code{\link[=datetimeoffset]{datetimeoffset()}} support for the following S3 methods from \code{lubridate}:
\itemize{
\item \code{year()}
\item \code{month()}
\item \code{mday()}
\item \code{hour()}
\item \code{minute()}
\item \code{second()}
\item \code{tz()}
\item \code{date()}
}
}
\examples{
library("clock")
if ("Europe/Paris" \%in\% OlsonNames()) {
  dt <- as_datetimeoffset("1918-11-11T11:11:11.1234+00:00[Europe/Paris]")
} else {
  dt <- as_datetimeoffset("1918-11-11T11:11:11.1234")
}
get_year(dt)
get_month(dt)
get_day(dt)
get_hour(dt)
get_minute(dt)
get_second(dt)
get_nanosecond(dt)
get_subsecond_digits(dt)
get_hour_offset(dt)
get_minute_offset(dt)
get_tz(dt)
if (require("lubridate")) {
  paste0(year(dt), "-", month(dt), "-", day(dt),
         "T", hour(dt), ":", minute(dt), ":", second(dt),
         "[", tz(dt), "]")
}
}
