% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_congruify.R
\name{congruify_and_mrca_multiPhylo}
\alias{congruify_and_mrca_multiPhylo}
\title{Congruify nodes of a tree topology to nodes from a source chronogram, and find the mrca nodes}
\usage{
congruify_and_mrca_multiPhylo(phy, source_chronograms)
}
\arguments{
\item{phy}{A \code{phylo} object.}

\item{source_chronograms}{A \code{multiPhylo} object, output of \code{\link[=datelife_search]{datelife_search()}}.}
}
\value{
a \code{data.frame} of node ages from \code{source_chronograms} and corresponding
mrca nodes in target tree \code{phy}.
}
\description{
\code{congruify_and_mrca_multiPhylo} congruifies a target tree against all
source chronograms in a \code{multiPhylo} object, and gets nodes of target tree
that correspond to the most recent common ancestor (mrca) of taxon pairs
in the congruified calibrations.
It calls \code{\link[=congruify_and_mrca_phylo]{congruify_and_mrca_phylo()}}, and \code{\link[phytools:findMRCA]{phytools::findMRCA()}} to get mrca nodes.
}
