% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_search.R
\name{is_datelife_result_empty}
\alias{is_datelife_result_empty}
\title{Check if we obtained an empty search with the given taxon name(s).}
\usage{
is_datelife_result_empty(datelife_result, use_tnrs = FALSE)
}
\arguments{
\item{datelife_result}{A \code{datelifeResult} object, usually an output of \code{\link[=get_datelife_result]{get_datelife_result()}}.}

\item{use_tnrs}{Whether to use Open Tree of Life's Taxonomic Name Resolution Service (TNRS)
to process input taxon names. Default to \code{TRUE}, it corrects misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}.}
}
\value{
Boolean. If \code{TRUE}, no chronograms were found for the given taxon name(s).
If \code{FALSE}, the chronogram search was successful.
}
\description{
Check if we obtained an empty search with the given taxon name(s).
}
