% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degrad.R
\encoding{UTF-8}
\name{load_degrad}
\alias{load_degrad}
\title{Degrad - Forest Degradation in the Brazilian Amazon}
\usage{
load_degrad(
  dataset = "degrad",
  raw_data = FALSE,
  time_period,
  language = "eng"
)
}
\arguments{
\item{dataset}{A dataset name ("degrad").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating for which years the data will be loaded, in the format YYYY. Can be any vector of numbers, such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{list} of tibbles (if \code{raw_data} = \code{TRUE}) or a tibble (if \code{raw_data} = \code{FALSE}).
}
\description{
Loads information on forest degradation in the Brazilian Amazon, replaced by DETER-B in December 2016.
}
\examples{
\dontrun{
# download treated data (raw_data = TRUE) related to forest degradation
# from 2010 to 2012 (time_period = 2010:2012).
data <- load_degrad(
  dataset = "degrad",
  raw_data = FALSE,
  time_period = 2010:2012
)
}

}
