% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_scale.R
\name{change_scale}
\alias{change_scale}
\alias{change_scale.numeric}
\alias{change_scale.grouped_df}
\alias{change_scale.data.frame}
\title{Rescale a numeric variable}
\usage{
change_scale(x, ...)

\method{change_scale}{numeric}(x, to = c(0, 100), range = NULL, verbose = TRUE, ...)

\method{change_scale}{grouped_df}(
  x,
  select = NULL,
  exclude = NULL,
  to = c(0, 100),
  range = NULL,
  ...
)

\method{change_scale}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  to = c(0, 100),
  range = NULL,
  ...
)
}
\arguments{
\item{x}{Object.}

\item{...}{Arguments passed to or from other methods.}

\item{to}{New range of values of the data after rescaling.}

\item{range}{Initial (old) range of values. If `NULL`, will take the range of
data.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{select}{Character vector of column names. If `NULL` (the default), all
variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}
}
\value{
A rescaled object.
}
\description{
Rescale a numeric variable to a new range.
}
\examples{
change_scale(c(0, 1, 5, -5, -2))
change_scale(c(0, 1, 5, -5, -2), to = c(-5, 5))

head(change_scale(trees))
}
\seealso{
[normalize()] [standardize()] [ranktransform()]

Other transform utilities: 
\code{\link{normalize}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
