% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_diffs.R
\name{get_diffs}
\alias{get_diffs}
\title{Get diffs}
\usage{
get_diffs(destination, collect = TRUE)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{collect}{should we collect the underlying arrow dataset or return just the connection?}
}
\value{
a data frame or an arrow dataset connection
}
\description{
Read in all the diffs in a versioned dataset to a data frame or arrow dataset
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
new_df <- data.frame(a = 2:5, b = letters[2:5])
diff <- diffdfs::diffdfs(new_df, df)
commit_diff(diff, temp_dir)

get_diffs(temp_dir)

unlink(temp_dir)

}
