% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataverse_search.R
\name{dataverse_search}
\alias{dataverse_search}
\title{Search Dataverse server}
\usage{
dataverse_search(
  ...,
  type = c("dataverse", "dataset", "file"),
  subtree = NULL,
  sort = c("name", "date"),
  order = c("asc", "desc"),
  per_page = 10,
  start = NULL,
  show_relevance = FALSE,
  show_facets = FALSE,
  fq = NULL,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  verbose = TRUE,
  http_opts = NULL
)
}
\arguments{
\item{\dots}{A length-one character vector specifying a search query, a named character vector of search arguments, or a sequence of named character arguments. The specific fields available may vary by server installation.}

\item{type}{A character vector specifying one or more of \dQuote{dataverse}, \dQuote{dataset}, and \dQuote{file}, which is used to restrict the search results. By default, all three types of objects are searched for.}

\item{subtree}{Currently ignored.}

\item{sort}{A character vector specifying whether to sort results by \dQuote{name} or \dQuote{date}.}

\item{order}{A character vector specifying either \dQuote{asc} or \dQuote{desc} results order.}

\item{per_page}{An integer specifying the page size of results.}

\item{start}{An integer specifying used for pagination.}

\item{show_relevance}{A logical indicating whether or not to show details of which fields were matched by the query}

\item{show_facets}{A logical indicating whether or not to show facets that can be operated on by the \code{fq} parameter}

\item{fq}{See API documentation.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \verb{DATAVERSE_SERVER = "dataverse.harvard.edu} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{verbose}{A logical indicating whether to display information about the search query (default is \code{TRUE}).}

\item{http_opts}{Currently ignored.}

\item{dataverse}{A character string specifying a Dataverse name or an object of class \dQuote{dataverse}.}
}
\value{
A list.
}
\description{
Search for Dataverses and datasets
}
\details{
This function provides an interface for searching for Dataverses, datasets, and/or files within a Dataverse server.
}
\examples{
\dontrun{
# simple string search
dataverse_search("Gary King")

# search using named arguments
dataverse_search(c(author = "Gary King", title = "Ecological Inference"))
dataverse_search(author = "Gary King", title = "Ecological Inference")

# search only for datasets
dataverse_search(author = "Gary King", type = "dataset")
}
}
\seealso{
\code{\link{get_file}}, \code{\link{get_dataverse}}, \code{\link{get_dataset}}, \code{\link{dataverse_contents}}
}
