% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bibentry.R
\name{get_bibentry}
\alias{get_bibentry}
\alias{set_bibentry<-}
\title{Get or set the bibentry}
\usage{
get_bibentry(dataset)

set_bibentry(dataset) <- value
}
\arguments{
\item{dataset}{A dataset created with \code{\link[=dataset_df]{dataset_df()}}.}

\item{value}{A \code{\link[utils:bibentry]{utils::bibentry}} to store on the dataset. If \code{NULL}, a
minimal default entry is created.}
}
\value{
\itemize{
\item \code{get_bibentry(dataset)} returns the \code{\link[utils:bibentry]{utils::bibentry}} stored in
\code{dataset}'s attributes.
\item \code{set_bibentry(dataset) <- value} sets the attribute and returns the
modified dataset invisibly.
}
}
\description{
Retrieve or replace the bibliographic entry stored in a dataset's attributes.
The entry is a \code{\link[utils:bibentry]{utils::bibentry}} used to hold citation metadata for
\code{\link[=dataset_df]{dataset_df()}} objects.
}
\details{
New datasets are initialized with reasonable defaults. To build a new
bibentry with sensible defaults and field names, use \code{\link[=datacite]{datacite()}} (DataCite)
or \code{\link[=dublincore]{dublincore()}} (Dublin Core), then assign it with
\code{set_bibentry(dataset) <- value}.

See the vignette for more background:
\code{vignette("bibentry", package = "dataset")}.
}
\examples{
# Get the bibentry of a dataset_df object:
be <- get_bibentry(orange_df)

# Create a well-formed bibentry (DataCite-style):
be2 <- datacite(
  Creator = person("Jane", "Doe"),
  Title = "The Orange Trees Dataset",
  Publisher = "MyOrg"
)

# Assign the new bibentry:
set_bibentry(orange_df) <- be2

# Inspect in different notations:
as_datacite(orange_df, type = "list")
as_dublincore(orange_df, type = "list")

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
