% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publication_year.R
\name{publication_year}
\alias{publication_year}
\alias{publication_year<-}
\title{Get/set the publication_year of the object.}
\usage{
publication_year(x)

publication_year(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{An R object, such as a data.frame, a tibble, or a data.table.}

\item{overwrite}{If the attributes should be overwritten. In case it is set to \code{FALSE},
it gives a message with the current \code{PublicationYear} property instead of overwriting it.
Defaults to \code{TRUE} when the attribute is set to \code{value} regardless of previous
setting.}

\item{value}{The publication_year as a character set.}
}
\value{
The \code{publication_year} attribute as a character of length 1 is added to \code{x}.
}
\description{
Get/set the optional \code{publication_year} property as an attribute to an R object.
}
\details{
The \code{PublicationYear} is the year when the data was or will be made
publicly available in \code{YYYY} format.
}
\examples{
iris_dataset <- iris
publication_year(iris_dataset) <- 1935
publication_year(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{dataset_source}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{size}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
