% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datasaurus-package.r
\docType{data}
\name{twelve_from_slant_alternate_wide}
\alias{twelve_from_slant_alternate_wide}
\title{Twelve From Slant Alternate (wide) data}
\format{A data frame with 182 rows and 24 variables:
\itemize{
\item \strong{bullseye_x}: x-values for the \code{bullseye} dataset
\item \strong{bullseye_y}: y-values for the \code{bullseye} dataset
\item \strong{circle_x}: x-values for the \code{circle} dataset
\item \strong{circle_y}: y-values for the \code{circle} dataset
\item \strong{dots_x}: x-values for the \code{dots} dataset
\item \strong{dots_y}: y-values for the \code{dots} dataset
\item \strong{h_lines_x}: x-values for the \code{h_lines} dataset
\item \strong{h_lines_y}: y-values for the \code{h_lines} dataset
\item \strong{high_lines_x}: x-values for the \code{high_lines} dataset
\item \strong{high_lines_y}: y-values for the \code{high_lines} dataset
\item \strong{slant_x}: x-values for the \code{slant} dataset
\item \strong{slant_y}: y-values for the \code{slant} dataset
\item \strong{slant_down_x}: x-values for the \code{slant_down} dataset
\item \strong{slant_down_y}: y-values for the \code{slant_down} dataset
\item \strong{slant_up_x}: x-values for the \code{slant_up} dataset
\item \strong{slant_up_y}: y-values for the \code{slant_up} dataset
\item \strong{star_x}: x-values for the \code{star} dataset
\item \strong{star_y}: y-values for the \code{star} dataset
\item \strong{v_lines_x}: x-values for the \code{v_lines} dataset
\item \strong{v_lines_y}: y-values for the \code{v_lines} dataset
\item \strong{wide_lines_x}: x-values for the \code{wide_lines} dataset
\item \strong{wide_lines_y}: y-values for the \code{wide_lines} dataset
\item \strong{x_shape_x}: x-values for the \code{x_shape} dataset
\item \strong{x_shape_y}: y-values for the \code{x_shape} dataset
}}
\usage{
twelve_from_slant_alternate_wide
}
\description{
A dataset demonstrating the utility of visualization. These 12 datasets are equal in non-parametric measures: median,
interquartile range, and Spearman's rank correlation.
}
\examples{
#save current settings
state <- par("mar", "mfrow")

# plot
par(mfrow = c(4, 3), mar=c(1,3,3,1))

nms <- names(twelve_from_slant_alternate_wide)
for (i in seq(1, 23, by = 2)){
  nm <- substr(nms[i], 1, nchar(nms[i]) - 2)
  plot(twelve_from_slant_alternate_wide[[nms[i]]],
       twelve_from_slant_alternate_wide[[nms[i+1]]],
       xlab = "", ylab = "", main = nm)
}

#reset settings
par(state)
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.autodeskresearch.com/publications/samestats}.
}
\keyword{datasets}
