% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectToDataRobot.R
\name{ConnectToDataRobot}
\alias{ConnectToDataRobot}
\title{Establish a connection to the DataRobot modeling engine}
\usage{
ConnectToDataRobot(endpoint = NULL, token = NULL, username = NULL,
  password = NULL, userAgentSuffix = NULL, sslVerify = TRUE,
  configPath = NULL)
}
\arguments{
\item{endpoint}{character. URL specifying the DataRobot server to be used.
It depends on DataRobot modeling engine implementation (cloud-based, on-prem...) you are using.
Contact your DataRobot admin for endpoint to use and to turn on API access to your account.
The endpoint for DataRobot cloud accounts is https://app.datarobot.com/api/v2}

\item{token}{character. DataRobot API access token. It is unique for each DataRobot modeling
engine account and can be accessed using DataRobot webapp in Account profile section.}

\item{username}{character. No longer supported.}

\item{password}{character. No longer supported.}

\item{userAgentSuffix}{character. Additional text that is appended to the
User-Agent HTTP header when communicating with the DataRobot REST API. This
can be useful for identifying different applications that are built on top
of the DataRobot Python Client, which can aid debugging and help track
usage.}

\item{sslVerify}{logical. Whether to check the SSL certificate. Either
TRUE to check (default), FALSE to not check.}

\item{configPath}{character. Path to YAML config file specifying configuration
(token and endpoint).}
}
\description{
This function initializes a DataRobot session. To use DataRobot, you must connect to
your account. This can be done in three ways:
\itemize{
  \item by passing an \code{endpoint} and \code{token} directly to \code{ConnectToDataRobot}
  \item by having a YAML config file in $HOME/.config/datarobot/drconfig.yaml
  \item by setting DATAROBOT_API_ENDPOINT and DATAROBOT_API_TOKEN environment variables
}
The three methods of authentication are given priority in that order (explicitly passing
parameters to the function will trump a YAML config file, which will trump the environment
variables.)
If you have a YAML config file or environment variables set, you will not need to
pass any parameters to \code{ConnectToDataRobot} in order to connect.
}
\examples{
\dontrun{
  ConnectToDataRobot("https://app.datarobot.com/api/v2", "thisismyfaketoken")
  ConnectToDataRobot(configPath = "~/.config/datarobot/drconfig.yaml")
}
}
