% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetModelCapabilities}
\alias{GetModelCapabilities}
\title{Get supported capabilities for a model, e.g., whether it has a word cloud.}
\usage{
GetModelCapabilities(model)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}
}
\value{
Returns
  \itemize{
     \item supportsBlending logical. Whether or not the model supports blending. See
       \code{RequestBlender}.
     \item supportsMonotonicConstraints logical. Whether or not the model supports monotonic
       constraints. See \code{RequestModel}
     \item hasWordCloud logical. Whether or not the model has a word cloud. See
       \code{GetWordCloud}.
     \item eligibleForPrime logical. Whether or not the model is eligible for Prime.
       See \code{CreatePrimeCode}.
     \item hasParameters logical. Whether or not the model has parameters. See
       \code{GetModelParameters}.
  }
}
\description{
Get supported capabilities for a model, e.g., whether it has a word cloud.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  GetModelCapabilities(model)
}
}
