% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureImpact.R
\name{GetFeatureImpactForJobId}
\alias{GetFeatureImpactForJobId}
\title{Retrieve completed Feature Impact results given a job ID}
\usage{
GetFeatureImpactForJobId(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{character. The project the Feature Impact is part of.}

\item{jobId}{character. The ID of the job (e.g. as returned from RequestFeatureImpact)}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete}
}
\value{
A data frame with the following columns:
\itemize{
  \item featureName character. The name of the feature.
  \item impactNormalized numeric. The normalized impact score (largest value is 1).
  \item impactUnnormalized numeric. The unnormalized impact score.
  \item redundantWith character. A feature that makes this feature redundant, or \code{NA}
    if the feature is not redundant.
  }
}
\description{
This will wait for the Feature Impact job to be completed (giving an error if the job is not a
Feature Impact job and an error if the job errors).
}
\examples{
\dontrun{
  model <- ListModels(project)[[1]]
  featureImpactJobId <- RequestFeatureImpact(model)
  featureImpact <- GetFeatureImpactForJobId(project, featureImpactJobId)
}
}
