% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_referred_vars.R
\name{util_referred_vars}
\alias{util_referred_vars}
\title{For a group of variables (original) the function provides all original plus
referred variables in the metadata and a new item_level metadata
including information on the original variables and the referred variables}
\usage{
util_referred_vars(
  resp_vars,
  id_vars = character(0),
  vars_in_subgroup = character(0),
  meta_data,
  meta_data_segment = NULL,
  meta_data_dataframe = NULL,
  meta_data_cross_item = NULL,
  meta_data_item_computation = NULL,
  strata_column = NULL
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the original variables.}

\item{id_vars}{\link{variable} a vector containing the name/s of the variables
containing ids}

\item{vars_in_subgroup}{\link{variable} a vector containing the name/s of the
variable/s mentioned inside the
subgroup rule}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional if \code{study_data} is present:
Data frame level metadata}

\item{meta_data_cross_item}{\link{data.frame} -- optional: Cross-item level
metadata}

\item{meta_data_item_computation}{\link{data.frame} -- optional: Computed items
metadata}

\item{strata_column}{\link{variable} name of a study variable used to stratify the
report by and to add as referred variable}
}
\value{
a named list containing the referred variables and
a new item_level metadata including information on the original variables
and the referred variables
}
\description{
For a group of variables (original) the function provides all original plus
referred variables in the metadata and a new item_level metadata
including information on the original variables and the referred variables
}
\keyword{internal}
