% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_acc_loess_bin.R
\name{util_acc_loess_bin}
\alias{util_acc_loess_bin}
\title{Utility function for smoothed longitudinal trends from logistic regression models}
\usage{
util_acc_loess_bin(
  resp_vars,
  label_col = NULL,
  study_data,
  item_level = "item_level",
  group_vars = NULL,
  time_vars,
  co_vars = NULL,
  min_obs_in_subgroup = 30,
  resolution = 80,
  plot_format = getOption("dataquieR.acc_loess.plot_format",
    dataquieR.acc_loess.plot_format_default),
  meta_data = item_level,
  n_group_max = getOption("dataquieR.max_group_var_levels_in_plot",
    dataquieR.max_group_var_levels_in_plot_default),
  enable_GAM = getOption("dataquieR.GAM_for_LOESS", dataquieR.GAM_for_LOESS.default),
  exclude_constant_subgroups =
    getOption("dataquieR.acc_loess.exclude_constant_subgroups",
    dataquieR.acc_loess.exclude_constant_subgroups.default)
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the (binary) measurement variable}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{group_vars}{\link{variable} the name of the observer, device or
reader variable}

\item{time_vars}{\link{variable} the name of the variable giving the time
of measurement}

\item{co_vars}{\link{variable list} a vector of co-variables, e.g. age and sex for
adjustment}

\item{min_obs_in_subgroup}{\link{integer} from=0. This optional argument specifies
the minimum number of observations that is required to
include a subgroup (level) of the \code{group_var} in the
analysis. Subgroups with less observations are
excluded.}

\item{resolution}{\link{integer} the maximum number of time points used for
plotting the trend lines}

\item{plot_format}{\link{enum} AUTO | COMBINED | FACETS | BOTH. Return the plot
as one combined plot for all groups or as
facet plots (one figure per group). \code{BOTH} will
return both variants, \code{AUTO} will decide based
on the number of observers.}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{n_group_max}{\link{integer} maximum number of categories to be displayed
individually for the grouping variable (\code{group_vars},
devices / examiners)}

\item{enable_GAM}{\link{logical} Can LOESS computations be replaced by general
additive models to reduce memory consumption  for large
datasets?}

\item{exclude_constant_subgroups}{\link{logical} Should subgroups with constant
values be excluded?}
}
\value{
a \link{list} with:
\itemize{
\item \code{SummaryPlotList}: a plot.
}
}
\description{
This function is under development. It computes a logistic regression for
binary variables and visualizes smoothed time trends of the residuals by
LOESS or GAM. The function can also be called for non-binary outcome
variables. These will be transformed to binary variables, either using
user-specified groups in the metadata columns \code{RECODE_CASES} and/or
\code{RECODE_CONTROL} (see \code{util_dichotomize}), or it will attempt to recode the
variables automatically. For nominal variables, it will consider the most
frequent category as 'cases' and every other category as 'control', if there
are more than two categories. Nominal variables with only two distinct values
will be transformed by assigning the less frequent category to 'cases' and
the more frequent category to 'control'. For variables of other statistical
data types, values inside the interquartile range are considered as
'control', values outside this range as 'cases'. Variables with few
different values are transformed in a simplified way to obtain two groups.
}
\details{
\link{Descriptor}
}
\keyword{internal}
