% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000_globs.R
\docType{data}
\name{SCALE_LEVELS}
\alias{SCALE_LEVELS}
\title{Scale Levels}
\format{
An object of class \code{list} of length 5.
}
\usage{
SCALE_LEVELS
}
\description{
\subsection{Scale Levels of Study Data according to \verb{Stevens's} Typology}{

In the metadata, the following entries are allowed for the
\link{variable attribute} \link{SCALE_LEVEL}:
}
}
\details{
\itemize{
\item \code{nominal} for categorical variables
\item \code{ordinal} for ordinal variables (i.e., comparison of values is possible)
\item \code{interval} for interval scales, i.e., distances are meaningful
\item \code{ratio} for ratio scales, i.e., ratios are meaningful
\item \code{na} for variables, that contain e.g. unstructured texts, \code{json},
\code{xml}, ... to distinguish them from variables, that still need to
have the \code{SCALE_LEVEL} estimated by
\code{prep_scalelevel_from_data_and_metadata()}
}
\subsection{Examples}{
\itemize{
\item sex, eye color -- \code{nominal}
\item income group, education level -- \code{ordinal}
\item temperature in degree Celsius -- \code{interval}
\item body weight, temperature in Kelvin -- \code{ratio}
}
}
}
\seealso{
\href{https://en.wikipedia.org/wiki/Level_of_measurement}{Wikipedia}
}
\keyword{datasets}
